import phonenumbers
from email_validator import validate_email, EmailNotValidError

def validate_email_address(email):
    try:
        valid = validate_email(email)
        return {"valid": True, "normalized": valid.email}
    except EmailNotValidError:
        return {"valid": False}

def validate_phone_number(number, country="NG"):
    try:
        parsed = phonenumbers.parse(number, country)
        return {
            "valid": phonenumbers.is_valid_number(parsed),
            "international": phonenumbers.format_number(parsed, phonenumbers.PhoneNumberFormat.E164)
        }
    except:
        return {"valid": False}
